/*
 * Decompiled with CFR 0.152.
 */
package fonnymunkey.simplehats.util;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import fonnymunkey.simplehats.SimpleHats;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.Level;

public class UUIDHandler {
    private static final String uuidUrl = "https://raw.githubusercontent.com/fonnymunkey/SimpleHatsAux/main/Fabric-1.18.2/uuids.json";
    private static final String zipUrl = "https://raw.githubusercontent.com/fonnymunkey/SimpleHatsAux/main/Fabric-1.18.2/simplehats_fabric_1.18.2_hatdl.zip";
    private static Map<String, Integer> uuidMap = new HashMap<String, Integer>();

    public static void setupUUIDMap() {
        try {
            URL url = new URL(uuidUrl);
            BufferedReader read = new BufferedReader(new InputStreamReader(url.openStream()));
            uuidMap = (Map)new Gson().fromJson((Reader)read, new TypeToken<Map<String, Integer>>(){}.getType());
            read.close();
        }
        catch (Exception ex) {
            SimpleHats.logger.log(Level.WARN, "Failed to fetch UUID file: " + ex);
        }
    }

    public static void checkResourceUpdates() {
        try {
            String fileString;
            JsonObject json;
            Map uuidMapPre;
            File parent = FabricLoader.getInstance().getConfigDir().resolve("simplehats_hatdl").toFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            File uuidFile = new File(parent, "uuids.json");
            File zipFile = new File(parent, "simplehats_hatdl.zip");
            boolean changed = uuidFile.exists() ? !(uuidMapPre = (Map)new Gson().fromJson((JsonElement)(json = JsonParser.parseString((String)(fileString = com.google.common.io.Files.asCharSource((File)uuidFile, (Charset)Charset.defaultCharset()).read())).getAsJsonObject()), new TypeToken<Map<String, Integer>>(){}.getType())).equals(uuidMap) : true;
            if (changed) {
                if (uuidFile.exists()) {
                    uuidFile.delete();
                }
                if (zipFile.exists()) {
                    zipFile.delete();
                }
                URL uuidURL = new URL(uuidUrl);
                Files.copy(uuidURL.openStream(), uuidFile.toPath(), new CopyOption[0]);
                URL zipURL = new URL(zipUrl);
                Files.copy(zipURL.openStream(), zipFile.toPath(), new CopyOption[0]);
            }
        }
        catch (Exception ex) {
            SimpleHats.logger.log(Level.WARN, "Failed to handle model downloading: " + ex);
        }
    }

    public static Map<String, Integer> getUUIDMap() {
        return uuidMap;
    }
}

